/*
 * Decompiled with CFR 0.152.
 */
package org.redisson;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.redisson.RedissonMultimap;
import org.redisson.RedissonSet;
import org.redisson.RedissonSetMultimapIterator;
import org.redisson.api.RFuture;
import org.redisson.api.RSet;
import org.redisson.api.RSetMultimap;
import org.redisson.client.codec.Codec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.client.protocol.convertor.BooleanAmountReplayConvertor;
import org.redisson.client.protocol.convertor.BooleanReplayConvertor;
import org.redisson.command.CommandAsyncExecutor;

public class RedissonSetMultimap<K, V>
extends RedissonMultimap<K, V>
implements RSetMultimap<K, V> {
    private static final RedisStrictCommand<Boolean> SCARD_VALUE = new RedisStrictCommand<Boolean>("SCARD", new BooleanAmountReplayConvertor());
    private static final RedisCommand<Boolean> SISMEMBER_VALUE = new RedisCommand<Boolean>("SISMEMBER", new BooleanReplayConvertor());

    public RedissonSetMultimap(CommandAsyncExecutor connectionManager, String name) {
        super(connectionManager, name);
    }

    public RedissonSetMultimap(Codec codec, CommandAsyncExecutor connectionManager, String name) {
        super(codec, connectionManager, name);
    }

    @Override
    public RFuture<Integer> sizeAsync() {
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_INTEGER, "local keys = redis.call('hgetall', KEYS[1]); local size = 0; for i, v in ipairs(keys) do if i % 2 == 0 then local name = ARGV[1] .. v; size = size + redis.call('scard', name); end;end; return size; ", Arrays.asList(this.getName()), this.prefix);
    }

    @Override
    public RFuture<Boolean> containsKeyAsync(Object key) {
        ByteBuf keyState = this.encodeMapKey(key);
        String keyHash = this.hashAndRelease(keyState);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.readAsync(this.getName(), this.codec, SCARD_VALUE, setName);
    }

    @Override
    public RFuture<Boolean> containsValueAsync(Object value) {
        ByteBuf valueState = this.encodeMapValue(value);
        return this.commandExecutor.evalReadAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local keys = redis.call('hgetall', KEYS[1]); for i, v in ipairs(keys) do if i % 2 == 0 then local name = ARGV[2] .. v; if redis.call('sismember', name, ARGV[1]) == 1 then return 1; end;end;end; return 0; ", Arrays.asList(this.getName()), valueState, this.prefix);
    }

    @Override
    public RFuture<Boolean> containsEntryAsync(Object key, Object value) {
        ByteBuf keyState = this.encodeMapKey(key);
        String keyHash = this.hashAndRelease(keyState);
        ByteBuf valueState = this.encodeMapValue(value);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.readAsync(this.getName(), this.codec, SISMEMBER_VALUE, setName, valueState);
    }

    @Override
    public RFuture<Boolean> putAsync(K key, V value) {
        ByteBuf keyState = this.encodeMapKey(key);
        String keyHash = this.hash(keyState);
        ByteBuf valueState = this.encodeMapValue(value);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); return redis.call('sadd', KEYS[2], ARGV[3]); ", Arrays.asList(this.getName(), setName), keyState, keyHash, valueState);
    }

    @Override
    public RFuture<Boolean> removeAsync(Object key, Object value) {
        ByteBuf keyState = this.encodeMapKey(key);
        String keyHash = this.hash(keyState);
        ByteBuf valueState = this.encodeMapValue(value);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN, "local res = redis.call('srem', KEYS[2], ARGV[2]); if res == 1 and redis.call('scard', KEYS[2]) == 0 then redis.call('hdel', KEYS[1], ARGV[1]); end; return res; ", Arrays.asList(this.getName(), setName), keyState, valueState);
    }

    @Override
    public RFuture<Boolean> putAllAsync(K key, Iterable<? extends V> values) {
        ArrayList<Object> params = new ArrayList<Object>();
        ByteBuf keyState = this.encodeMapKey(key);
        params.add(keyState);
        String keyHash = this.hash(keyState);
        params.add(keyHash);
        for (V value : values) {
            ByteBuf valueState = this.encodeMapValue(value);
            params.add(valueState);
        }
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN_AMOUNT, "redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); return redis.call('sadd', KEYS[2], unpack(ARGV, 3, #ARGV)); ", Arrays.asList(this.getName(), setName), params.toArray());
    }

    @Override
    public RSet<V> get(final K key) {
        ByteBuf keyState = this.encodeMapKey(key);
        String keyHash = this.hashAndRelease(keyState);
        final String setName = this.getValuesName(keyHash);
        return new RedissonSet<V>(this.codec, this.commandExecutor, setName, null){

            @Override
            public RFuture<Boolean> addAsync(V value) {
                return RedissonSetMultimap.this.putAsync(key, value);
            }

            @Override
            public RFuture<Boolean> addAllAsync(Collection<? extends V> c) {
                return RedissonSetMultimap.this.putAllAsync(key, c);
            }

            @Override
            public RFuture<Boolean> removeAsync(Object value) {
                return RedissonSetMultimap.this.removeAsync(key, value);
            }

            @Override
            public RFuture<Boolean> removeAllAsync(Collection<?> c) {
                ByteBuf keyState = this.encodeMapKey(key);
                return this.commandExecutor.evalWriteAsync(RedissonSetMultimap.this.getName(), this.codec, RedisCommands.EVAL_BOOLEAN_AMOUNT, "redis.call('hdel', KEYS[1], ARGV[1]); return redis.call('del', KEYS[2]); ", Arrays.asList(RedissonSetMultimap.this.getName(), setName), keyState);
            }

            @Override
            public RFuture<Boolean> deleteAsync() {
                ByteBuf keyState = this.encodeMapKey(key);
                return RedissonSetMultimap.this.fastRemoveAsync(Arrays.asList(keyState), Arrays.asList(setName), RedisCommands.EVAL_BOOLEAN_AMOUNT);
            }

            @Override
            public RFuture<Boolean> clearExpireAsync() {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }

            @Override
            public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit) {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }

            @Override
            public RFuture<Boolean> expireAtAsync(long timestamp) {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }

            @Override
            public RFuture<Long> remainTimeToLiveAsync() {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }

            @Override
            public RFuture<Void> renameAsync(String newName) {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }

            @Override
            public RFuture<Boolean> renamenxAsync(String newName) {
                throw new UnsupportedOperationException("This operation is not supported for SetMultimap values Set");
            }
        };
    }

    @Override
    public Set<V> getAll(K key) {
        return (Set)super.getAll(key);
    }

    @Override
    public RFuture<Collection<V>> getAllAsync(K key) {
        ByteBuf keyState = this.encodeMapKey(key);
        String keyHash = this.hashAndRelease(keyState);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.readAsync(this.getName(), this.codec, RedisCommands.SMEMBERS, setName);
    }

    @Override
    public Set<V> removeAll(Object key) {
        return (Set)this.get(this.removeAllAsync(key));
    }

    @Override
    public RFuture<Collection<V>> removeAllAsync(Object key) {
        ByteBuf keyState = this.encodeMapKey(key);
        String keyHash = this.hash(keyState);
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_SET, "redis.call('hdel', KEYS[1], ARGV[1]); local members = redis.call('smembers', KEYS[2]); redis.call('del', KEYS[2]); return members; ", Arrays.asList(this.getName(), setName), keyState);
    }

    @Override
    public Set<Map.Entry<K, V>> entries() {
        return (Set)super.entries();
    }

    @Override
    public Set<V> replaceValues(K key, Iterable<? extends V> values) {
        return (Set)this.get(this.replaceValuesAsync(key, values));
    }

    @Override
    Iterator<V> valuesIterator() {
        return new RedissonSetMultimapIterator<K, V, V>(this, this.commandExecutor, this.codec){

            @Override
            V getValue(V entry) {
                return entry;
            }
        };
    }

    @Override
    RedissonSetMultimapIterator<K, V, Map.Entry<K, V>> entryIterator() {
        return new RedissonSetMultimapIterator(this, this.commandExecutor, this.codec);
    }

    @Override
    public RFuture<Collection<V>> replaceValuesAsync(K key, Iterable<? extends V> values) {
        ArrayList<Object> params = new ArrayList<Object>();
        ByteBuf keyState = this.encodeMapKey(key);
        params.add(keyState);
        String keyHash = this.hash(keyState);
        params.add(keyHash);
        for (V value : values) {
            ByteBuf valueState = this.encodeMapValue(value);
            params.add(valueState);
        }
        String setName = this.getValuesName(keyHash);
        return this.commandExecutor.evalWriteAsync(this.getName(), this.codec, RedisCommands.EVAL_SET, "redis.call('hset', KEYS[1], ARGV[1], ARGV[2]); local members = redis.call('smembers', KEYS[2]); redis.call('del', KEYS[2]); redis.call('sadd', KEYS[2], unpack(ARGV, 3, #ARGV)); return members; ", Arrays.asList(this.getName(), setName), params.toArray());
    }
}

