/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm.storage;

import de.javakaffee.web.msm.NamedThreadFactory;
import de.javakaffee.web.msm.storage.StorageClient;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import redis.clients.jedis.BinaryJedis;
import redis.clients.jedis.exceptions.JedisConnectionException;

public class RedisStorageClient
implements StorageClient {
    protected static final Log _log = LogFactory.getLog(RedisStorageClient.class);
    private final URI _uri;
    private final int _timeout;
    private final JedisPool _pool = new JedisPool();
    private final ExecutorService _executor = Executors.newCachedThreadPool(new NamedThreadFactory("msm-redis-client"));

    public RedisStorageClient(String redisUrl, long operationTimeout) {
        if (redisUrl == null) {
            throw new NullPointerException("Param \"redisUrl\" may not be null");
        }
        if (_log.isDebugEnabled()) {
            _log.debug(String.format("Creating RedisStorageClient with URL \"%s\"", redisUrl));
        }
        try {
            this._uri = this.createURI(redisUrl);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error parsing redisUrl", e);
        }
        this._timeout = (int)operationTimeout;
    }

    URI createURI(String redisUrl) throws URISyntaxException {
        URI uri = new URI(redisUrl);
        if (uri.getPort() < 0) {
            uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), 6379, uri.getPath(), uri.getQuery(), uri.getFragment());
        }
        return uri;
    }

    @Override
    public Future<Boolean> add(final String key, final int exp, final byte[] o) {
        if (_log.isDebugEnabled()) {
            _log.debug(String.format("Adding key to Redis (key=%s, exp=%s, o=%s)", key, exp, o.getClass().getName()));
        }
        return this._executor.submit(new RedisCommandCallable<Boolean>(){
            private volatile boolean _setCompleted;

            @Override
            protected Boolean execute(BinaryJedis jedis) throws Exception {
                byte[] kb = RedisStorageClient.keyBytes(key);
                if (this._setCompleted || jedis.setnx(kb, o) == 1L) {
                    this._setCompleted = true;
                    if (exp == 0) {
                        return true;
                    }
                    return jedis.expire(kb, RedisStorageClient.convertExp(exp)) == 1L;
                }
                return false;
            }
        });
    }

    @Override
    public Future<Boolean> set(final String key, final int exp, final byte[] o) {
        if (_log.isDebugEnabled()) {
            _log.debug(String.format("Setting key in Redis (key=%s, exp=%s, o=%s)", key, exp, o.getClass().getName()));
        }
        return this._executor.submit(new RedisCommandCallable<Boolean>(){

            @Override
            protected Boolean execute(BinaryJedis jedis) throws Exception {
                if (exp == 0) {
                    return jedis.set(RedisStorageClient.keyBytes(key), o).equals("OK");
                }
                return jedis.setex(RedisStorageClient.keyBytes(key), RedisStorageClient.convertExp(exp), o).equals("OK");
            }
        });
    }

    @Override
    public byte[] get(final String key) {
        if (_log.isDebugEnabled()) {
            _log.debug(String.format("Getting key from Redis (key=%s)", key));
        }
        RedisCommandCallable<byte[]> callable = new RedisCommandCallable<byte[]>(){

            @Override
            protected byte[] execute(BinaryJedis jedis) throws Exception {
                return jedis.get(RedisStorageClient.keyBytes(key));
            }
        };
        try {
            return (byte[])callable.call();
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException("Error getting key from Redis", e);
        }
    }

    @Override
    public Future<Boolean> delete(final String key) {
        if (_log.isDebugEnabled()) {
            _log.debug(String.format("Deleting key in Redis (key=%s)", key));
        }
        return this._executor.submit(new RedisCommandCallable<Boolean>(){

            @Override
            protected Boolean execute(BinaryJedis jedis) throws Exception {
                return jedis.del(RedisStorageClient.keyBytes(key)) == 1L;
            }
        });
    }

    @Override
    public void shutdown() {
        this._pool.shutdown();
    }

    private static int convertExp(int exp) {
        if (exp <= 2592000) {
            return exp;
        }
        return Math.max(exp - (int)(System.currentTimeMillis() / 1000L), 1);
    }

    private static byte[] keyBytes(String key) {
        try {
            return key.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private class JedisPool {
        private Queue<BinaryJedis> _queue = new ConcurrentLinkedQueue<BinaryJedis>();

        private JedisPool() {
        }

        public BinaryJedis borrowInstance(boolean knownGood) {
            BinaryJedis res = this._queue.poll();
            if (res == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug(String.format("Creating new Jedis instance (host=%s, port=%s, ssl=%s)", RedisStorageClient.this._uri.getHost(), RedisStorageClient.this._uri.getPort(), RedisStorageClient.this._uri.getScheme().startsWith("rediss")));
                }
                return this.createJedisInstance();
            }
            if (knownGood) {
                while (true) {
                    try {
                        res.ping();
                        if (_log.isTraceEnabled()) {
                            _log.trace(String.format("Using known-good connection #%d", this._queue.size()));
                        }
                        return res;
                    }
                    catch (Exception e) {
                        if (_log.isDebugEnabled()) {
                            _log.debug(String.format("Removing connection #%d since it cannot be pinged", this._queue.size()));
                        }
                        try {
                            res.close();
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if ((res = this._queue.poll()) != null) continue;
                        if (_log.isDebugEnabled()) {
                            _log.debug(String.format("Creating new Jedis instance (host=%s, port=%s, ssl=%s) since all existing connections were bad", RedisStorageClient.this._uri.getHost(), RedisStorageClient.this._uri.getPort(), RedisStorageClient.this._uri.getScheme().startsWith("rediss")));
                        }
                        return this.createJedisInstance();
                    }
                    break;
                }
            }
            if (_log.isTraceEnabled()) {
                _log.trace(String.format("Using connection #%d", this._queue.size()));
            }
            return res;
        }

        public void returnInstance(BinaryJedis instance) {
            this._queue.offer(instance);
            if (_log.isTraceEnabled()) {
                _log.trace(String.format("Returned instance #%d", this._queue.size()));
            }
        }

        public void shutdown() {
            BinaryJedis instance;
            if (_log.isDebugEnabled()) {
                _log.debug(String.format("Closing %d Jedis instance(s)", this._queue.size()));
            }
            while ((instance = this._queue.poll()) != null) {
                try {
                    instance.close();
                }
                catch (Exception exception) {}
            }
        }

        private BinaryJedis createJedisInstance() {
            BinaryJedis binaryJedis = new BinaryJedis(RedisStorageClient.this._uri);
            binaryJedis.getClient().setConnectionTimeout(RedisStorageClient.this._timeout);
            binaryJedis.getClient().setSoTimeout(RedisStorageClient.this._timeout);
            return binaryJedis;
        }
    }

    private abstract class RedisCommandCallable<T>
    implements Callable<T> {
        private RedisCommandCallable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call() throws Exception {
            BinaryJedis jedis = null;
            try {
                jedis = RedisStorageClient.this._pool.borrowInstance(false);
                T t = this.execute(jedis);
                return t;
            }
            catch (JedisConnectionException e) {
                if (_log.isDebugEnabled()) {
                    _log.debug("Connection error occurred, discarding Jedis connection: " + e.getMessage());
                }
                if (jedis != null) {
                    try {
                        jedis.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                jedis = null;
            }
            finally {
                if (jedis != null) {
                    RedisStorageClient.this._pool.returnInstance(jedis);
                }
            }
            try {
                jedis = RedisStorageClient.this._pool.borrowInstance(true);
                T t = this.execute(jedis);
                return t;
            }
            finally {
                if (jedis != null) {
                    RedisStorageClient.this._pool.returnInstance(jedis);
                }
            }
        }

        protected abstract T execute(BinaryJedis var1) throws Exception;
    }
}

