/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.MemcachedNodesManager;
import de.javakaffee.web.msm.SessionIdFormat;
import de.javakaffee.web.msm.Statistics;
import de.javakaffee.web.msm.SuffixBasedNodeLocator;
import de.javakaffee.web.msm.TranscoderWrapperStatisticsSupport;
import java.util.List;
import net.spy.memcached.DefaultConnectionFactory;
import net.spy.memcached.FailureMode;
import net.spy.memcached.MemcachedNode;
import net.spy.memcached.NodeLocator;
import net.spy.memcached.transcoders.SerializingTranscoder;
import net.spy.memcached.transcoders.Transcoder;

public final class SuffixLocatorConnectionFactory
extends DefaultConnectionFactory {
    private final MemcachedNodesManager _memcachedNodesManager;
    private final SessionIdFormat _sessionIdFormat;
    private final Statistics _statistics;
    private final long _operationTimeout;
    private final long _maxReconnectDelay;

    public SuffixLocatorConnectionFactory(MemcachedNodesManager memcachedNodesManager, SessionIdFormat sessionIdFormat, Statistics statistics, long operationTimeout, long maxReconnectDelay) {
        this._memcachedNodesManager = memcachedNodesManager;
        this._sessionIdFormat = sessionIdFormat;
        this._statistics = statistics;
        this._operationTimeout = operationTimeout;
        this._maxReconnectDelay = maxReconnectDelay;
    }

    @Override
    public FailureMode getFailureMode() {
        return FailureMode.Cancel;
    }

    @Override
    public NodeLocator createLocator(List<MemcachedNode> nodes) {
        return new SuffixBasedNodeLocator(nodes, this._memcachedNodesManager, this._sessionIdFormat);
    }

    @Override
    public Transcoder<Object> getDefaultTranscoder() {
        SerializingTranscoder transcoder = new SerializingTranscoder();
        transcoder.setCompressionThreshold(16384);
        return new TranscoderWrapperStatisticsSupport(this._statistics, transcoder);
    }

    @Override
    public long getOperationTimeout() {
        return this._operationTimeout;
    }

    @Override
    public long getMaxReconnectDelay() {
        return this._maxReconnectDelay;
    }
}

