/*
 * Decompiled with CFR 0.152.
 */
package de.javakaffee.web.msm;

import de.javakaffee.web.msm.LRUCache;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;

public class ReadOnlyRequestsCache {
    private static final Comparator<AtomicLong> ATOMLONG_COMP = new Comparator<AtomicLong>(){

        @Override
        public int compare(AtomicLong o1, AtomicLong o2) {
            long val2;
            long val1 = o1.longValue();
            return val1 < (val2 = o2.longValue()) ? -1 : (val1 == val2 ? 0 : 1);
        }
    };
    private final Log _log = LogFactory.getLog(this.getClass());
    private final LRUCache<String, AtomicLong> _readOnlyRequests;
    private final LRUCache<String, AtomicLong> _blacklist;

    public ReadOnlyRequestsCache() {
        long sixHours = TimeUnit.HOURS.toMillis(6L);
        this._readOnlyRequests = new LRUCache(1000, sixHours);
        this._blacklist = new LRUCache(50000, sixHours);
    }

    public boolean readOnlyRequest(String requestId) {
        if (!this._blacklist.containsKey(requestId)) {
            if (this._log.isDebugEnabled()) {
                this._log.debug("Registering readonly request: " + requestId);
            }
            this.incrementOrPut(this._readOnlyRequests, requestId);
            return true;
        }
        return false;
    }

    public void modifyingRequest(String requestId) {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Registering modifying request: " + requestId);
        }
        this.incrementOrPut(this._blacklist, requestId);
        this._readOnlyRequests.remove(requestId);
    }

    public boolean isReadOnlyRequest(String requestId) {
        if (this._log.isDebugEnabled()) {
            this._log.debug("Asked for readonly request: " + requestId + " (" + this._readOnlyRequests.containsKey(requestId) + ")");
        }
        return this._readOnlyRequests.containsKey(requestId);
    }

    public List<String> getReadOnlyRequests() {
        return this._readOnlyRequests.getKeys();
    }

    public List<String> getReadOnlyRequestsByFrequency() {
        return this._readOnlyRequests.getKeysSortedByValue(ATOMLONG_COMP);
    }

    private void incrementOrPut(LRUCache<String, AtomicLong> cache, String requestURI) {
        AtomicLong count = cache.get(requestURI);
        if (count != null) {
            count.incrementAndGet();
        } else {
            cache.put(requestURI, new AtomicLong(1L));
        }
    }
}

